DROP TYPE W83B.TABLA_CABDELEGSINDCONV;
DROP TYPE W83B.tabla_COMEXTRACCIONDATOS;
DROP TYPE W83B.tabla_COMIMPUGRESUELTAS;
DROP TYPE W83B.tabla_comunicacionempresa;
DROP TYPE W83B.tabla_detalleActa;
DROP TYPE W83B.tabla_detalleActaCompleto;
DROP TYPE W83B.TABLA_DETALLEDELEGSINDCONV;
DROP TYPE W83B.tabla_empresavariospreavisos;
DROP TYPE W83B.TABLA_NUMEMPRESASYCENTROS;
DROP TYPE W83B.tabla_numeroactasregdef;
DROP TYPE W83B.tabla_resoldeneglaudoneg;
COMMIT;
/****************************************************************************************************************************************************************/

create or replace
TYPE      CABDELEGSINDCONV IS object  (totalelectores NUMBER,
                 totalvotos NUMBER,
                 empresa  VARCHAR2(10),
                 numcentros NUMBER);
/
/****************************************************************************************************************************************************************/

create or replace
TYPE      COMEXTRACCIONDATOS IS object  (
                 nacta NUMBER,
                 anoacta  NUMBER,
                 territ VARCHAR2(2),
                 nactacompleto NUMBER,
                 nimpug NUMBER,
                 anoimpug NUMBER,
                 nlaudo NUMBER,
                 anolaudo NUMBER,
                 flaudo DATE,
                 arbitro VARCHAR2(250),
                 cif VARCHAR2(10),
                 razon VARCHAR2(50),
                 sindicatos VARCHAR2(5000),
                 voces VARCHAR2(5000),
                 orderby VARCHAR2(1));
/
/****************************************************************************************************************************************************************/
create or replace
TYPE      COMIMPUGRESUELTAS IS object  (
                 nacta NUMBER,
                 anoacta  NUMBER,
                 territ VARCHAR2(2),
                 razon VARCHAR2(50),
                 domicilio VARCHAR2(50),
                 municipio NUMBER,
                 provincia NUMBER,
                 nimpug VARCHAR2(10000),
                 nactacompleto NUMBER,
                 codigopostal VARCHAR2(5),
                 orderby VARCHAR2(1),
                 dirorig VARCHAR2(200),
                 cporig VARCHAR2(5),
                 munorig VARCHAR2(3),
                 provorig VARCHAR2(2));
/                 
/****************************************************************************************************************************************************************/
create or replace
TYPE      comunicacionempresa IS object  (
                 ver NUMBER,
                 fechaentrada DATE,
                 nacta  NUMBER,
                 anoacta NUMBER,
                 territ VARCHAR2(2),
                 numpreaviso NUMBER,
                 anopreaviso NUMBER,
                 cif VARCHAR2(10),
                 codcentro NUMBER,
                 numerocentro NUMBER,
                 razon VARCHAR2(50),
                 domicilio VARCHAR2(50),
                 municipio VARCHAR2(3),
                 provincia VARCHAR2(2),
                 codigopostal VARCHAR2(5),
                 numactaint NUMBER,
                 dirorig VARCHAR2(200),
                 munorig VARCHAR2(3),
                 provorig VARCHAR2(2),
                 cporig VARCHAR2(5));
/                 
/****************************************************************************************************************************************************************/
create or replace
TYPE      detalleActa IS object  (numRegDef NUMBER,
                 fechaEntrada DATE,
                 fechaEleccion DATE,
                 numEntrada  VARCHAR2(15),
                 numActa NUMBER,
                 cif VARCHAR2(10),
                 numCentro NUMBER,
                 razonSocial VARCHAR2(50),
                 direccion VARCHAR2(50),
                 numTrabajadores NUMBER,
                 numRepresentantes NUMBER,
                 territorio VARCHAR2(2),
                 anoActa NUMBER,
                 nactaintcompleto VARCHAR2(15),
                 provincia varchar2(2),
                 municipio varchar2(3),
                 seccion varchar2(2),
                 ver NUMBER,
                 npreaviso NUMBER,
                 anopreaviso NUMBER,
                 codcentro NUMBER,
                 actatotal NUMBER
                 );
/                 
/****************************************************************************************************************************************************************/
create or replace
TYPE      detalleActaDatos IS object
         (       VERSION_016 number(2),
         ANO_ACTA_016 number(4),
         N_ACTA_016 number(6),
         C_TERRIT_016 varchar2(2),
         N_PREAVISO_016 number(6),
         ANO_PREAVISO_016 number(4),
         C_CONV_016 number(4),
         DESC_013 varchar2(250),
         DESE_013 varchar2(250),
         DESC_017 varchar2(250),
         DESE_017 varchar2(250),
         CBAJA_016 number(2),
         F_ENTRA_016 Date,
         F_ELECC_016 Date,
         FREGLIB_016 Date,
         FREGDEF_016 Date,
         F_COMIS_016 Date,
         F_REQUE_016 Date,
         F_SUBREQ_016 Date,
         F_RETCOM_016 Date,
         F_PRRI_016 Date,
         F_BAJA_016 Date,
         FACTU_016 Date,
         TOTELEC_016 number(6),
         CANDH_016 number(6),
         CANDM_016 number(6),
         ANO_ACTTOT_016 number(4),
         N_ACTTOT_016 number(6),
         N_REG_016 varchar2(15),
         ANO_REGDEF_016 number(4),
         N_REGDEF_016 varchar2(20),
         ELECH_016 number(6),
         ELECM_016 number(6),
         S_COMI_016 varchar2(1),
         OBSERV_016 varchar2(500),
         USUA_016 varchar2(15),
         INSPEC_016 number(1),
         F_CONSTCOM_016 Date,
         VALIDADA_016 varchar2(1),
         REMITE_016 varchar2(150),
         CCIF_001 varchar2(10),
         NCEN_001 number(3),
         CPOSC_001 varchar2(10),
         DOMIC_001 varchar2(50),
         PROVINCIA varchar2(50),
         MUNICIPIO varchar2(50),
         MUN_001 varchar2(3),
         PROVC_001 number(2),
         RSOC_001 varchar2(50),
         LOCAL_001 varchar2(30),
         MAXDEL_016 number(5),
         delegados number(6),
         delegadosh number(5),
         delegadosm number(5),
         totalEscr number(6),
         totalDif number(6),
         escrHombres0 number(6),
         escrHombres1 number(6),
         escrMujeres0 number(6),
         escrMujeres1 number(6),
         difHombres0 number(6),
         difHombres1 number(6),
         difMujeres0 number(6),
         difMujeres1 number(6),
     ID_CENTRO_016 number(6)
);
/
/****************************************************************************************************************************************************************/
create or replace
TYPE      DETALLEDELEGSINDCONV IS object  (
                 nacta NUMBER,
                 anoacta NUMBER,
                 territ VARCHAR2(2),
                 ver NUMBER,
                 codSindicato NUMBER,
                 siglas VARCHAR2(10),
                 sinddesc VARCHAR2(250),
                 sinddese VARCHAR2(250),
                 tipoconvenio  VARCHAR2(1),
                 numdelegados NUMBER,
                 nregdef  NUMBER,
                 anoregdef NUMBER,
                 ncentro NUMBER,
                 cif VARCHAR2(10),
                 razon VARCHAR2(50),
                 felec DATE,
                 fechaactu DATE,
                 totalelectores NUMBER);
/
/****************************************************************************************************************************************************************/
create or replace
TYPE      empresavariospreavisos IS object  (cif VARCHAR2(10),
                 codigocentro NUMBER,
                 razon  VARCHAR2(50),
                 fechaentrada DATE,
                 numpreaviso VARCHAR2(15),
                 numpreavisoint NUMBER,
                 fechainicio DATE,
                 municipio VARCHAR2(50),
                 preavisoglobal VARCHAR2(1),
                 observaciones VARCHAR2(500),
                 promotores VARCHAR2(10000),
                 promotoreseu VARCHAR2(10000),
                 territ VARCHAR2(2));
/                 
/****************************************************************************************************************************************************************/
create or replace
TYPE      NUMEMPRESASYCENTROS IS object  (
                 numcentros NUMBER);
/                 
/****************************************************************************************************************************************************************/
create or replace
TYPE      numeroactasregdef IS object  (
                 numeroactas NUMBER
                 );
/                 
/****************************************************************************************************************************************************************/
create or replace
TYPE      resoldeneglaudoneg IS object  (fechaEntrada DATE,
                 nacta NUMBER,
                 anoacta  NUMBER,
                 territ VARCHAR2(2),
                 npre NUMBER,
                 anopreaviso NUMBER,
                 razon VARCHAR2(50),
                 domicilio VARCHAR2(50),
                 municipio VARCHAR2(50),
                 numelectores NUMBER,
                 numrepresentantes NUMBER,
                 freque DATE,
                 fimpug DATE,
                 fregdef DATE);
/                 
/****************************************************************************************************************************************************************/
create or replace
TYPE string_agg_type AS OBJECT (
  total VARCHAR2(4000),
  static FUNCTION ODCIAggregateInitialize(sctx IN OUT string_agg_type )
  RETURN NUMBER,
  MEMBER FUNCTION ODCIAggregateIterate(self IN OUT string_agg_type, value IN VARCHAR2 )
  RETURN NUMBER,
  MEMBER FUNCTION ODCIAggregateTerminate(self IN string_agg_type, returnValue OUT VARCHAR2, flags IN NUMBER)
  RETURN NUMBER,
  MEMBER FUNCTION ODCIAggregateMerge(self IN OUT string_agg_type, ctx2 IN string_agg_type)
  RETURN NUMBER
);	
/
/****************************************************************************************************************************************************************/
create or replace
TYPE string_agg_int AS OBJECT (
  total VARCHAR2(4000),
  static FUNCTION ODCIAggregateInitialize(sctx IN OUT string_agg_int )
  RETURN NUMBER,
  MEMBER FUNCTION ODCIAggregateIterate(self IN OUT string_agg_int, value IN VARCHAR2 )
  RETURN NUMBER,
  MEMBER FUNCTION ODCIAggregateTerminate(self IN string_agg_int, returnValue OUT VARCHAR2, flags IN NUMBER)
  RETURN NUMBER,
  MEMBER FUNCTION ODCIAggregateMerge(self IN OUT string_agg_int, ctx2 IN string_agg_int)
  RETURN NUMBER
);
/
/****************************************************************************************************************************************************************/
create or replace
TYPE      TABLA_CABDELEGSINDCONV IS TABLE OF W83B.CABDELEGSINDCONV;
/
/****************************************************************************************************************************************************************/
create or replace
TYPE      tabla_COMEXTRACCIONDATOS IS TABLE OF W83B.COMEXTRACCIONDATOS;
/
/****************************************************************************************************************************************************************/
create or replace
TYPE      tabla_COMIMPUGRESUELTAS IS TABLE OF W83B.COMIMPUGRESUELTAS;
/
/****************************************************************************************************************************************************************/
create or replace
TYPE      tabla_comunicacionempresa IS TABLE OF W83B.comunicacionempresa;
/
/****************************************************************************************************************************************************************/
create or replace
TYPE      tabla_detalleActa IS TABLE OF W83B.detalleActa;
/
/****************************************************************************************************************************************************************/
create or replace
TYPE      tabla_detalleActaCompleto IS TABLE OF W83B.detalleActaDatos;
/
/****************************************************************************************************************************************************************/
create or replace
TYPE      TABLA_DETALLEDELEGSINDCONV IS TABLE OF W83B.DETALLEDELEGSINDCONV;
/
/****************************************************************************************************************************************************************/
create or replace
TYPE      tabla_empresavariospreavisos IS TABLE OF W83B.empresavariospreavisos;
/
/****************************************************************************************************************************************************************/
create or replace
TYPE      TABLA_NUMEMPRESASYCENTROS IS TABLE OF W83B.NUMEMPRESASYCENTROS;
/
/****************************************************************************************************************************************************************/
create or replace
TYPE      tabla_numeroactasregdef IS TABLE OF W83B.numeroactasregdef;
/
/****************************************************************************************************************************************************************/
create or replace
TYPE      tabla_resoldeneglaudoneg IS TABLE OF W83B.resoldeneglaudoneg;
/
/****************************************************************************************************************************************************************/
